<?php

namespace App\Http\Controllers;

use App\Models\Modul;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class ProfilController extends Controller
{
    public function index()
    {
        $m = Modul::where('kode', 'PFTG')->first();
        $data = [
            'title' => 'Ramizah Store | Tentang Kami',
            'page' => 'Tentang Kami',
            'menuActive' => 'tentang',
            'menuOpen' => 'profil',
        ];
        return view('admin.profile.profil', compact('data', 'm'));
    }

    public function update(Request $request): RedirectResponse
    {
        $id = $request->id;

        $modul = Modul::findOrFail($id);

        if ($request->kode == 'PFTG' || $request->kode == 'PFLY') {
            $modul->update([
                'judul' => $request->judul,
                'isi' => $request->isi,
            ]);
        } else {
            $modul->update([
                'judul' => $request->judul,
                'isi' => $request->isi,
                'link' => $request->link,
                'gambar' => $request->gambar,
            ]);
        }


        return redirect()->back()->with(['success' => 'Perubahan Data Berhasil Disimpan!']);
    }

    public function layanan()
    {
        $m = Modul::where('kode', 'PFLY')->first();
        $data = [
            'title' => 'Ramizah Store | Layanan Kami',
            'page' => 'Layanan Kami',
            'menuActive' => 'layanan',
            'menuOpen' => 'profil',
        ];
        return view('admin.profile.profil', compact('data', 'm'));
    }

    public function kontak()
    {
        $m = Modul::where('kode', 'PFKT')->first();
        $data = [
            'title' => 'Ramizah Store | Kontak Kami',
            'page' => 'Kontak Kami',
            'menuActive' => 'kontak',
            'menuOpen' => 'profil',
        ];
        return view('admin.profile.kontak', compact('data', 'm'));
    }
}
